﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Public Class SurveyForm

    '创建所需的私有变量以存放信息。
    Private surveyTitleValue As String = "Survey"
    Private surveyResponseValue As String = "Survey Not Completed"

    ' 创建一个属性，以便于检索控件。
    Public ReadOnly Property SurveyFormControls() As Control.ControlCollection
        Get
            Return Me.Controls
        End Get
    End Property

    ' 创建一个高度属性，以便于更改高度。
    Public Property SurveyHeight() As Integer
        Get
            Return Me.Height
        End Get
        Set(ByVal Value As Integer)
            Me.Height = Value
        End Set
    End Property

    ' 创建一个属性，以便于检索响应。
    Public ReadOnly Property SurveyResponse() As String
        Get
            Return surveyResponseValue
        End Get
    End Property

    ' 创建一个属性，以便于检索和设置
    ' 窗体的标题。
    Public Property SurveyTitle() As String
        Get
            Return surveyTitleValue
        End Get
        Set(ByVal Value As String)
            surveyTitleValue = Value
            Me.Text = surveyTitleValue
        End Set
    End Property

    ' 创建一个宽度属性，以便于更改宽度。
    Public Property SurveyWidth() As Integer
        Get
            Return Me.Width
        End Get
        Set(ByVal Value As Integer)
            Me.Width = Value
        End Set
    End Property

    '仅重置 SurveyResponse 字符串并关闭窗体。
    Private Sub btnCancel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCancel.Click
        '重置 SurveyResponse 字符串。
        surveyResponseValue = "Survey Not Completed"

        '关闭窗体。
        Me.Close()
    End Sub

    '此按钮首先填充 SurveyResponse 字符串，然后关闭窗体。
    Private Sub btnOK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnOK.Click

        '创建在后面的所有循环中将要使用的控件。
        Dim aControl As Control
        Dim aGroupControl As Control
        Dim anObject As Object

        '重置 Response 字符串
        Me.surveyResponseValue = ""

        '循环访问每个控件并将用户响应输出到
        'SurveyResponse 字符串中。（字符串可以轻松地替换为
        '某些种类的集合。）
        For Each aControl In Me.Controls
            '使输出因控件类型而不同
            Select Case TypeName(aControl)
                Case "ComboBox"
                    '只从分组框中获取文本并将其与问题名称一同
                    '添加到响应字符串中
                    surveyResponseValue += aControl.Name + " - "
                    surveyResponseValue += aControl.Text
                    surveyResponseValue += vbCrLf
                Case "TextBox"
                    '只从分组框中获取文本并将其与问题名称一同
                    '添加到响应字符串中
                    surveyResponseValue += aControl.Name + " - "
                    surveyResponseValue += aControl.Text
                    surveyResponseValue += vbCrLf
                Case "GroupBox"
                    '需要进入 GroupBox 内部，
                    '以提取 RadioButton
                    For Each aGroupControl In CType(aControl, GroupBox).Controls
                        If TypeOf aGroupControl Is RadioButton Then
                            If CType(aGroupControl, RadioButton).Checked Then
                                '只获取正在调查的用户
                                '的问题和响应。
                                surveyResponseValue += aControl.Name + " - "
                                surveyResponseValue += aGroupControl.Text
                                surveyResponseValue += vbCrLf
                            End If
                        End If

                    Next
                Case "ListBox"
                    '对于此情况，必须获取每个选定行，
                    '并将其返回。
                    surveyResponseValue += aControl.Name + " - "
                    For Each anObject In CType(aControl, ListBox).SelectedItems
                        If TypeOf anObject Is String Then
                            '只获取正在调查的用户
                            '的问题和响应。
                            surveyResponseValue += vbTab + CStr(anObject)
                            surveyResponseValue += vbCrLf
                        End If
                    Next
            End Select
        Next

        '关闭窗体。
        Me.Close()
    End Sub


End Class